<?php

class USIN_Report_Loader{

	public $label_col = 'label';
	public $total_col = 'total';
	public $max_items  = 8;

	protected $group_filters;

	public function __construct($report, $options = array()){
		$this->report = $report;
		$this->options = $options;
		$this->group_filters = new StdClass();

		if(!empty($this->options['group_filters'])){
			$this->group_filters = $this->options['group_filters'];
		}

		$this->setup();

		$this->max_items = apply_filters('usin_max_report_items', $this->max_items, $report);
		
	}

	public function call(){
		$data = $this->load_data();

		if(is_wp_error($data)){
			return $data;
		}
		
		return $this->format_data($data);
	}

	protected function data_item($name, $result){
		return (object)array($this->label_col => $name, $this->total_col => $result);
	}

	/**
	 * Can be used by child classes to run additional code upon initialization.
	 *
	 */
	protected function setup(){}


	protected function getSelectedFilter(){
		return $this->options['filter'];
	}

	protected function get_page(){
		$page = 0;

		if(isset($this->options['page']) && intval($this->options['page']) > 0){
			$page = intval($this->options['page']);
		}

		return $page;
	}

	protected function get_selected_group_filter($key){
		return isset($this->group_filters->$key) ? $this->group_filters->$key : null;
	}
}